/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.__builtin__;
import org.python.modules.PyIOFile;
import org.python.modules.cStringIO;

public class PyIOFileFactory {
    private static PyType FileType = PyType.fromClass(PyFile.class);

    private PyIOFileFactory() {
    }

    public static PyIOFile createIOFile(PyObject pyObject) {
        Object object = pyObject.__tojava__(cStringIO.StringIO.class);
        if (object != Py.NoConversion) {
            return new cStringIOFile(pyObject);
        }
        if (__builtin__.isinstance(pyObject, FileType)) {
            return new FileIOFile(pyObject);
        }
        return new ObjectIOFile(pyObject);
    }

    static class FileIOFile
    implements PyIOFile {
        PyFile file;

        FileIOFile(PyObject pyObject) {
            this.file = (PyFile)pyObject.__tojava__(PyFile.class);
            if (this.file.getClosed()) {
                throw Py.ValueError("I/O operation on closed file");
            }
        }

        public void write(String string) {
            this.file.write(string);
        }

        public void write(char c) {
            this.file.write(cStringIO.getString(c));
        }

        public void flush() {
        }

        public String read(int n) {
            return this.file.read(n).toString();
        }

        public String readlineNoNl() {
            String string = this.file.readline().toString();
            return string.substring(0, string.length() - 1);
        }
    }

    static class ObjectIOFile
    implements PyIOFile {
        char[] charr = new char[1];
        StringBuilder buff = new StringBuilder();
        PyObject write;
        PyObject read;
        PyObject readline;
        final int BUF_SIZE = 256;

        ObjectIOFile(PyObject pyObject) {
            this.write = pyObject.__findattr__("write");
            this.read = pyObject.__findattr__("read");
            this.readline = pyObject.__findattr__("readline");
        }

        public void write(String string) {
            this.buff.append(string);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        public void write(char c) {
            this.buff.append(c);
            if (this.buff.length() > 256) {
                this.flush();
            }
        }

        public void flush() {
            this.write.__call__(new PyString(this.buff.toString()));
            this.buff.setLength(0);
        }

        public String read(int n) {
            return this.read.__call__(new PyInteger(n)).toString();
        }

        public String readlineNoNl() {
            String string = this.readline.__call__().toString();
            return string.substring(0, string.length() - 1);
        }
    }

    static class cStringIOFile
    implements PyIOFile {
        cStringIO.StringIO file;

        cStringIOFile(PyObject pyObject) {
            this.file = (cStringIO.StringIO)pyObject.__tojava__(Object.class);
        }

        public void write(String string) {
            this.file.write(string);
        }

        public void write(char c) {
            this.file.writeChar(c);
        }

        public void flush() {
        }

        public String read(int n) {
            return this.file.read(n).asString();
        }

        public String readlineNoNl() {
            return this.file.readlineNoNl().asString();
        }
    }
}

